/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_ShortcutConstants;
import com.izforge.izpack.util.os.unix.ShellScript;
import com.izforge.izpack.util.os.unix.UnixHelper;
import com.izforge.izpack.util.os.unix.UnixUser;
import com.izforge.izpack.util.os.unix.UnixUsers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class Unix_Shortcut
extends Shortcut
implements Unix_ShortcutConstants {
    private static String version = "$Id: Unix_Shortcut.java 1816 2007-04-23 19:57:27Z jponge $";
    private static String rev = "$Revision: 1816 $";
    private static String DESKTOP_EXT = ".desktop";
    private static String template = "";
    private static final String N = "\n";
    private static final String H = "#";
    private static final String S = " ";
    private static final String C = "# ";
    private static final String QM = "\"";
    private int ShortcutType;
    private static ShellScript rootScript = null;
    private static ShellScript uninstallScript = null;
    private static ArrayList users = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
    private String createdDirectory;
    private int itsUserType;
    private String itsGroupName;
    private String itsName;
    private String itsFileName;
    private String itsApplnkFolder = "applnk";
    private Properties props;
    private Boolean forAll = Boolean.FALSE;
    public StringBuffer hlp = new StringBuffer();

    public Unix_Shortcut() {
        String userLanguage = System.getProperty("user.language", "en");
        this.hlp.append("[Desktop Entry]\n");
        this.hlp.append("Categories=$Categories\n");
        this.hlp.append("Comment=$Comment\n");
        this.hlp.append("Comment[").append(userLanguage).append("]=$Comment\n");
        this.hlp.append("Encoding=$Encoding\n");
        this.hlp.append("Exec=$E_QUOT$Exec$E_QUOT $Arguments\n");
        this.hlp.append("GenericName=$GenericName\n");
        this.hlp.append("GenericName[").append(userLanguage).append("]=$GenericName\n");
        this.hlp.append("Icon=$Icon\n");
        this.hlp.append("MimeType=$MimeType\n");
        this.hlp.append("Name=$Name\n");
        this.hlp.append("Name[").append(userLanguage).append("]=$Name\n");
        this.hlp.append("Path=$P_QUOT$Path$P_QUOT\n");
        this.hlp.append("ServiceTypes=$ServiceTypes\n");
        this.hlp.append("SwallowExec=$SwallowExec\n");
        this.hlp.append("SwallowTitle=$SwallowTitle\n");
        this.hlp.append("Terminal=$Terminal\n");
        this.hlp.append("TerminalOptions=$Options_For_Terminal\n");
        this.hlp.append("Type=$Type\n");
        this.hlp.append("URL=$URL\n");
        this.hlp.append("X-KDE-SubstituteUID=$X_KDE_SubstituteUID\n");
        this.hlp.append("X-KDE-Username=$X_KDE_Username\n");
        this.hlp.append(N);
        this.hlp.append("# created by ").append(this.getClass().getName()).append(S).append(rev).append(N);
        this.hlp.append(C).append(version);
        template = this.hlp.toString();
        this.props = new Properties();
        this.initProps();
        if (rootScript == null) {
            rootScript = new ShellScript();
        }
        if (uninstallScript == null) {
            uninstallScript = new ShellScript();
        }
    }

    private void initProps() {
        String[] propsArray = new String[]{"$Comment", "$$LANG_Comment", "$Encoding", "$Exec", "$Arguments", "$GenericName", "$$LANG_GenericName", "$MimeType", "$Name", "$$LANG_Name", "$Path", "$ServiceTypes", "$SwallowExec", "$SwallowTitle", "$Terminal", "$Options_For_Terminal", "$Type", "$X_KDE_SubstituteUID", "$X_KDE_Username", "$Icon", "$URL", "$E_QUOT", "$P_QUOT", "$Categories", "$TryExec"};
        for (int i = 0; i < propsArray.length; ++i) {
            this.props.put(propsArray[i], "");
        }
    }

    public void initialize(int aType, String aName) throws Exception {
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    public boolean supported() {
        return true;
    }

    public String getDirectoryCreated() {
        return this.createdDirectory;
    }

    public String getFileName() {
        return this.itsFileName;
    }

    public Vector getProgramGroups(int userType) {
        Vector<String> groups = new Vector<String>();
        File kdeShareApplnk = this.getKdeShareApplnkFolder(userType);
        try {
            File[] listing = kdeShareApplnk.listFiles();
            for (int i = 0; i < listing.length; ++i) {
                if (!listing[i].isDirectory()) continue;
                groups.add(listing[i].getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return groups;
    }

    public String getProgramsFolder(int current_user) {
        String result = "";
        result = this.getKdeShareApplnkFolder(current_user).toString();
        return result;
    }

    private File getKdeShareApplnkFolder(int userType) {
        File kdeBase = this.getKdeBase(userType);
        File result = new File(kdeBase + File.separator + "share" + File.separator + this.getKdeApplinkFolderName());
        return result;
    }

    private String getKdeApplinkFolderName() {
        String applinkFolderName = "applnk";
        if (OsVersion.IS_REDHAT_LINUX) {
            applinkFolderName = "applnk-redhat";
        }
        if (OsVersion.IS_MANDRAKE_LINUX) {
            applinkFolderName = "applnk-mdk";
        }
        return applinkFolderName;
    }

    private File getKdeBase(int userType) {
        File result = null;
        if (userType == 2) {
            FileExecutor fe = new FileExecutor();
            String[] execOut = new String[2];
            int execResult = fe.executeCommand(new String[]{"/usr/bin/env", "kde-config", "--prefix"}, execOut);
            result = new File(execOut[0].trim());
        } else {
            result = new File(System.getProperty("user.home") + File.separator + ".kde");
        }
        return result;
    }

    public boolean multipleUsers() {
        return true;
    }

    public void save() throws Exception {
        String FS = File.separator;
        String chmod = UnixHelper.getCustomCommand("chmod");
        String chown = UnixHelper.getCustomCommand("chown");
        String rm = UnixHelper.getRmCommand();
        String copy = UnixHelper.getCpCommand();
        String su = UnixHelper.getSuCommand();
        String myHome = System.getProperty("user.home");
        String target = null;
        String shortCutDef = this.replace();
        boolean rootUser4All = this.getUserType() == 2;
        boolean create4All = this.getCreateForAll();
        if ("".equals(this.itsGroupName) && this.getLinkType() == 3) {
            this.itsFileName = target = myHome + FS + "Desktop" + FS + this.itsName + DESKTOP_EXT;
            File writtenDesktopFile = this.writeShortCut(target, shortCutDef);
            if (rootUser4All && create4All) {
                File dest = null;
                File tempFile = File.createTempFile(this.getClass().getName(), Long.toString(System.currentTimeMillis()) + ".tmp");
                Unix_Shortcut.copyTo(writtenDesktopFile, tempFile);
                FileExecutor.getExecOutput(new String[]{chmod, "uga+rwx", tempFile.toString()});
                for (int idx = 0; idx < users.size(); ++idx) {
                    UnixUser user = (UnixUser)users.get(idx);
                    if (user.getHome().equals(myHome)) {
                        Debug.log("need not to copy for itself: " + user.getHome() + "==" + myHome);
                        continue;
                    }
                    try {
                        dest = new File(user.getHome() + FS + "Desktop" + FS + writtenDesktopFile.getName());
                        rootScript.append(su);
                        rootScript.append(S);
                        rootScript.append(user.getName());
                        rootScript.append(S);
                        rootScript.append("-c");
                        rootScript.append(S);
                        rootScript.append('\"');
                        rootScript.append(copy);
                        rootScript.append(S);
                        rootScript.append(tempFile.toString());
                        rootScript.append(S);
                        rootScript.append(StringTool.replace(dest.toString(), S, "\\ "));
                        rootScript.appendln('\"');
                        rootScript.append('\n');
                        rootScript.append(chown);
                        rootScript.append(S);
                        rootScript.append(user.getName());
                        rootScript.append(S);
                        rootScript.appendln(StringTool.replace(dest.toString(), S, "\\ "));
                        rootScript.append('\n');
                        rootScript.append('\n');
                        uninstallScript.append(su);
                        uninstallScript.append(S);
                        uninstallScript.append(user.getName());
                        uninstallScript.append(S);
                        uninstallScript.append("-c");
                        uninstallScript.append(S);
                        uninstallScript.append('\"');
                        uninstallScript.append(rm);
                        uninstallScript.append(S);
                        uninstallScript.append(StringTool.replace(dest.toString(), S, "\\ "));
                        uninstallScript.appendln('\"');
                        uninstallScript.appendln();
                        continue;
                    }
                    catch (Exception rex) {
                        System.out.println("Error while su Copy: " + rex.getLocalizedMessage() + "\n\n");
                        rex.printStackTrace();
                    }
                }
                rootScript.append(rm);
                rootScript.append(S);
                rootScript.appendln(tempFile.toString());
                rootScript.appendln();
            }
        } else {
            String categoryobject = this.props.getProperty("$Categories");
            if (categoryobject != null && categoryobject.length() > 0) {
                File kdeHomeShareApplnk = this.getKdeShareApplnkFolder(this.getUserType());
                this.itsFileName = target = kdeHomeShareApplnk.toString() + FS + this.itsGroupName + FS + this.itsName + DESKTOP_EXT;
                File kdemenufile = this.writeShortCut(target, shortCutDef);
                this.uninstaller.addFile(kdemenufile.toString());
            }
            if (rootUser4All && create4All) {
                File theIcon = new File(this.getIconLocation());
                File commonIcon = new File("/usr/share/pixmaps/" + theIcon.getName());
                try {
                    Unix_Shortcut.copyTo(theIcon, commonIcon);
                    this.uninstaller.addFile(commonIcon.toString());
                }
                catch (Exception cnc) {
                    Debug.log("Could Not Copy: " + theIcon + " to " + commonIcon + "( " + cnc.getMessage() + " )");
                }
                String commonTarget = "/usr/share/applications/" + this.itsName + DESKTOP_EXT;
                this.itsFileName = target;
                File writtenFile = this.writeShortCut(commonTarget, shortCutDef);
                this.uninstaller.addFile(writtenFile.toString());
            } else {
                String localApps = myHome + "/.local/share/applications/";
                String localPixmaps = myHome + "/.local/share/pixmaps/";
                try {
                    File f = new File(localApps);
                    f.mkdirs();
                    f = new File(localPixmaps);
                    f.mkdirs();
                }
                catch (Exception ignore) {
                    Debug.log("Failed creating " + localApps + " or " + localPixmaps);
                }
                File theIcon = new File(this.getIconLocation());
                File commonIcon = new File(localPixmaps + theIcon.getName());
                try {
                    Unix_Shortcut.copyTo(theIcon, commonIcon);
                    this.uninstaller.addFile(commonIcon.toString());
                }
                catch (Exception cnc) {
                    Debug.log("Could Not Copy: " + theIcon + " to " + commonIcon + "( " + cnc.getMessage() + " )");
                }
                String commonTarget = localApps + this.itsName + DESKTOP_EXT;
                this.itsFileName = target;
                File writtenFile = this.writeShortCut(commonTarget, shortCutDef);
                this.uninstaller.addFile(writtenFile.toString());
            }
        }
    }

    public void execPostAction() {
        Debug.log("Call of Impl. execPostAction Method in " + this.getClass().getName());
        String pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        String scriptFilename = null;
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e.printStackTrace();
        }
        rootScript.write(scriptFilename);
        rootScript.exec();
        Debug.log(rootScript);
        Debug.log(uninstallScript);
        this.uninstaller.addRootUninstallScript(uninstallScript.getContentAsString());
    }

    public static void copyTo(File inFile, File outFile) throws IOException {
        char[] cbuff = new char[32768];
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        int readedBytes = 0;
        long absWrittenBytes = 0L;
        while ((readedBytes = reader.read(cbuff, 0, cbuff.length)) != -1) {
            writer.write(cbuff, 0, readedBytes);
            absWrittenBytes += (long)readedBytes;
        }
        reader.close();
        writer.close();
    }

    private File writeShortCut(String target, String shortCutDef) {
        File targetPath = new File(target.substring(0, target.lastIndexOf(File.separatorChar)));
        if (!targetPath.exists()) {
            targetPath.mkdirs();
            this.createdDirectory = targetPath.toString();
        }
        File targetFileName = new File(target);
        File backupFile = new File(targetPath + File.separator + "." + targetFileName.getName() + System.currentTimeMillis());
        if (targetFileName.exists()) {
            try {
                Unix_Shortcut.copyTo(targetFileName, backupFile);
                targetFileName.delete();
            }
            catch (IOException e3) {
                System.out.println("cannot create backup file " + backupFile + " of " + targetFileName);
            }
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(targetFileName);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        try {
            fileWriter.write(shortCutDef);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return targetFileName;
    }

    public void setArguments(String args) {
        this.props.put("$Arguments", args);
    }

    public void setDescription(String description) {
        this.props.put("$Comment", description);
    }

    public void setIconLocation(String path, int index) {
        this.props.put("$Icon", path);
    }

    public void setLinkName(String aName) {
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    public void setLinkType(int aType) throws IllegalArgumentException, UnsupportedEncodingException {
        this.ShortcutType = aType;
    }

    public void setProgramGroup(String aGroupName) {
        this.itsGroupName = aGroupName;
    }

    public void setShowCommand(int show) {
    }

    public void setTargetPath(String aPath) {
        StringTokenizer whiteSpaceTester = new StringTokenizer(aPath);
        if (whiteSpaceTester.countTokens() > 1) {
            this.props.put("$E_QUOT", QM);
        }
        this.props.put("$Exec", aPath);
    }

    public void setUserType(int aUserType) {
        this.itsUserType = aUserType;
    }

    public void setWorkingDirectory(String aDirectory) {
        StringTokenizer whiteSpaceTester = new StringTokenizer(aDirectory);
        if (whiteSpaceTester.countTokens() > 1) {
            this.props.put("$P_QUOT", QM);
        }
        this.props.put("$Path", aDirectory);
    }

    public String toString() {
        return this.itsName + N + template;
    }

    public String replace() {
        String result = template;
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result = StringTool.replace(result, key, this.props.getProperty(key));
        }
        return result;
    }

    public static void main(String[] args) {
        Unix_Shortcut aSample = new Unix_Shortcut();
        try {
            aSample.initialize(1, "Start Tomcat");
        }
        catch (Exception exc) {
            System.err.println("Could not init Unix_Shourtcut");
        }
        aSample.replace();
        System.out.println(aSample);
        File targetFileName = new File(System.getProperty("user.home") + File.separator + "Start Tomcat" + DESKTOP_EXT);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(targetFileName);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            fileWriter.write(template);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void setEncoding(String aEncoding) {
        this.props.put("$Encoding", aEncoding);
    }

    public void setKdeSubstUID(String trueFalseOrNothing) {
        this.props.put("$X_KDE_SubstituteUID", trueFalseOrNothing);
    }

    public void setKdeUserName(String aUserName) {
        this.props.put("$X_KDE_Username", aUserName);
    }

    public void setMimetype(String aMimetype) {
        this.props.put("$MimeType", aMimetype);
    }

    public void setTerminal(String trueFalseOrNothing) {
        this.props.put("$Terminal", trueFalseOrNothing);
    }

    public void setTerminalOptions(String someTerminalOptions) {
        this.props.put("$Options_For_Terminal", someTerminalOptions);
    }

    public void setType(String aType) {
        this.props.put("$Type", aType);
    }

    public void setURL(String anUrl) {
        this.props.put("$URL", anUrl);
    }

    public int getUserType() {
        return this.itsUserType;
    }

    public void setCategories(String theCategories) {
        this.props.put("$Categories", theCategories);
    }

    public void setTryExec(String aTryExec) {
        this.props.put("$TryExec", aTryExec);
    }

    public int getLinkType() {
        return this.ShortcutType;
    }
}

