//*******************************************************************************
// COPYRIGHT NOTES
// ---------------
// This is a part of the BCGControlBar Library
// Copyright (C) 1998-2000 BCGSoft Ltd.
// All rights reserved.
//
// This source code can be used, distributed or modified
// only under terms and conditions 
// of the accompanying license agreement.
//*******************************************************************************

#if !defined(AFX_BCGPROPLIST_H__8E7648AE_215A_4D66_B6B1_6656A7D6D357__INCLUDED_)
#define AFX_BCGPROPLIST_H__8E7648AE_215A_4D66_B6B1_6656A7D6D357__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// BCGPropList.h : header file
//

#ifndef __AFXTEMPL_H__
	#include "afxtempl.h"
#endif

#include "comdef.h"
#include "bcgcontrolbar.h"
#include "ColorPopup.h"
#include "BCGHeaderCtrl.h"

/////////////////////////////////////////////////////////////////////////////
// CBCGProp object

class BCGCONTROLBARDLLEXPORT CBCGProp : public CObject
{
	DECLARE_DYNAMIC(CBCGProp)

	friend class CBCGPropList;

// Construction
public:
	// Group constructor
	CBCGProp(const CString& strGroupName, DWORD dwData = 0);

	// Simple property
	CBCGProp(const CString& strName, const _variant_t& varValue, 
		LPCTSTR lpszDescr = NULL, DWORD dwData = 0,
		LPCTSTR lpszEditMask = NULL, LPCTSTR lpszEditTemplate = NULL,
		LPCTSTR lpszValidChars = NULL);

	virtual ~CBCGProp();

	enum ClickArea
	{
		ClickExpandBox,
		ClickName,
		ClickValue
	};

// Operations:
public:
	int GetExpandedSubItems () const;
	BOOL AddSubItem (CBCGProp* pProp);

	BOOL AddOption (LPCTSTR lpszOption);
	void RemoveAllOptions ();

	CBCGProp* HitTest (CPoint point, CBCGProp::ClickArea* pnArea = NULL);

	void Expand (BOOL bExpand = TRUE);
	void Redraw ();

protected:
	void Init ();
	void SetFlags ();
	void SetOwnerList (CBCGPropList* pWndList);
	void Repos (int& y);
	void AddTerminalProp (CList<CBCGProp*, CBCGProp*>& lstProps);

	BOOL IsSubItem (CBCGProp* pProp) const;
	CBCGProp* FindSubItemByData (DWORD dwData) const;

// Overrides
public:
	virtual void OnDrawName (CDC* pDC, CRect rect);
	virtual void OnDrawValue (CDC* pDC, CRect rect);
	virtual void OnDrawExpandBox (CDC* pDC, CRect rectExpand);
	virtual void OnDrawButton (CDC* pDC, CRect rectButton);

	virtual CString FormatProperty ();

	virtual BOOL OnUpdateValue ();
	virtual BOOL OnEdit (LPPOINT lptClick);
	virtual CWnd* CreateInPlaceEdit (CRect rectEdit, BOOL& bDefaultFormat);

	virtual BOOL OnEndEdit ();

	virtual void OnClickButton (CPoint point);
	virtual BOOL OnDblClick (CPoint point);

	virtual void OnSelectCombo ();
	virtual void OnCloseCombo();

	virtual BOOL OnSetCursor () const;
	virtual BOOL PushChar (UINT nChar);

	virtual CString GetNameTooltip ();
	virtual CString GetValueTooltip ();

	virtual void OnClickName (CPoint /*point*/) {}
	virtual void OnRClickName (CPoint /*point*/) {}
	virtual void OnRClickValue (CPoint /*point*/, BOOL /*bSelChanged*/) {}

protected:
	virtual HBRUSH OnCtlColor(CDC* pDC, UINT nCtlColor);
	virtual CComboBox* CreateCombo (CWnd* pWndParent, CRect rect);
	virtual void OnDestroyWindow ();

	virtual BOOL OnKillFocus (CWnd* /*pNewWnd*/)
	{
		return TRUE;
	}

	virtual BOOL HasButton () const;

	virtual BOOL IsProcessFirstClick () const
	{
		return TRUE;
	}

// Attributes
public:
	const _variant_t& GetValue () const
	{
		return m_varValue;
	}

	const CString& GetName () const
	{
		return m_strName;
	}

	void SetName (LPCTSTR lpszName, BOOL bRedraw = TRUE);
	void SetValue (const _variant_t& varValue);

	const CString& GetDescription () const
	{
		return m_strDescr;
	}

	void SetDescription (const CString& strDescr)
	{
		m_strDescr = strDescr;
	}

	DWORD GetData () const
	{
		return m_dwData;
	}

	void SetData (DWORD dwData)
	{
		m_dwData = dwData;
	}

	BOOL IsGroup () const
	{
		return m_bGroup;
	}

	BOOL IsExpanded () const
	{
		return m_bExpanded;
	}

	BOOL IsParentExpanded () const;

	BOOL IsSelected () const;
	int GetHierarchyLevel () const;

	void Enable (BOOL bEnable = TRUE);
	BOOL IsEnabled () const
	{
		return m_bEnabled;
	}

	void AllowEdit (BOOL bAllow = TRUE)
	{
		ASSERT (m_varValue.vt != VT_BOOL);
		m_bAllowEdit = bAllow;
	}

	BOOL IsAllowEdit () const
	{
		return m_bAllowEdit;
	}

	CRect GetRect () const
	{
		return m_Rect;
	}

	int GetSubItemsCount () const
	{
		return m_lstSubItems.GetCount ();
	}

	CBCGProp* GetSubItem (int nIndex) const;

	CBCGProp* GetParent () const
	{
		return m_pParent;
	}

	BOOL IsInPlaceEditing () const
	{
		return m_bInPlaceEdit;
	}

public:
	// Data formats
	static CString	m_strFormatShort;
	static CString	m_strFormatLong;
	static CString	m_strFormatFloat;
	static CString	m_strFormatDouble;

protected:
	CString			m_strName;		// Property name
	_variant_t		m_varValue;		// Property value
	CBCGPropList*	m_pWndList;		// Pointer to the PropertyList window
	DWORD			m_dwData;		// User-defined data
	CString			m_strDescr;		// Property desciption
	CString			m_strEditMask;	// Property edit mask (see CBCGMaskEdit for description)
	CString			m_strEditTempl;	// Property edit template (see CBCGMaskEdit for description)
	CString			m_strValidChars;// Property edit valid chars (see CBCGMaskEdit for description)

	CStringList		m_lstOptions;	// List of combobox items

	BOOL			m_bInPlaceEdit;	// Is in InPalce editing mode

	CWnd*			m_pWndInPlace;	// Pointer to InPlace editing window
	CComboBox*		m_pWndCombo;	// Pointer to combbox

	CRect			m_Rect;			// Property rectangle (in the prop.list coordinates)
	CRect			m_rectButton;	// Drop down/open button rectangle
	BOOL			m_bButtonIsDown;// Is button pressed?
	
	BOOL			m_bGroup;		// Is property group?
	BOOL			m_bExpanded;	// Is property expanded (for groups only)
	BOOL			m_bEnabled;		// Is propperty enabled?
	BOOL			m_bAllowEdit;	// Is property editable?
	DWORD			m_dwFlags;		// Property flags

	CBCGProp*		m_pParent;		// Parent property (NULL for top-level properties)
	CList<CBCGProp*, CBCGProp*>	m_lstSubItems;	// Sub-properies list

	BOOL			m_bNameIsTrancated;
	BOOL			m_bValueIsTrancated;
};

/////////////////////////////////////////////////////////////////////////////
// CBCGColorProp object

class BCGCONTROLBARDLLEXPORT CBCGColorProp : public CBCGProp
{
	friend class CBCGPropList;

	DECLARE_DYNAMIC(CBCGColorProp)

// Construction
public:
	CBCGColorProp(const CString& strName, const COLORREF& color, 
		CPalette* pPalette = NULL, LPCTSTR lpszDescr = NULL, DWORD dwData = 0);
	virtual ~CBCGColorProp();

// Overrides
public:
	virtual void OnDrawValue (CDC* pDC, CRect rect);
	virtual void OnClickButton (CPoint point);
	virtual BOOL OnEdit (LPPOINT lptClick);
	virtual BOOL OnUpdateValue ();
	virtual CString FormatProperty ();

protected:
	virtual BOOL OnKillFocus (CWnd* pNewWnd)
	{
		return pNewWnd->GetSafeHwnd () != m_pPopup->GetSafeHwnd ();
	}

// Attributes
public:
	COLORREF GetColor () const
	{
		return m_Color;
	}

	void SetColor (COLORREF color);

	// Color popup attributes:
	void EnableAutomaticButton (LPCTSTR lpszLabel, COLORREF colorAutomatic, BOOL bEnable = TRUE);
	void EnableOtherButton (LPCTSTR lpszLabel, BOOL bAltColorDlg = TRUE, BOOL bEnable = TRUE);

// Attributes
protected:
	COLORREF					m_Color;			// Color value
	COLORREF					m_ColorAutomatic;	// Automatic (default) color value
	CString						m_strAutoColor;		// Atomatic color label
	BOOL						m_bStdColorDlg;		// Use standard Windows color dialog
	CString						m_strOtherColor;	// Alternative color label
	CColorPopup*				m_pPopup;
	CArray<COLORREF, COLORREF>	m_Colors;
};

/////////////////////////////////////////////////////////////////////////////
// CBCGFileProp object

class BCGCONTROLBARDLLEXPORT CBCGFileProp : public CBCGProp
{
	DECLARE_DYNAMIC(CBCGFileProp)

// Construction
public:
	CBCGFileProp(const CString& strName, const CString& strFolderName, DWORD dwData = 0, LPCTSTR lpszDescr = NULL);
	CBCGFileProp(const CString& strName, BOOL bOpenFileDialog, const CString& strFileName, 
				LPCTSTR lpszDefExt = NULL,
				DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
				LPCTSTR lpszFilter = NULL,
				LPCTSTR lpszDescr = NULL, DWORD dwData = 0);
	virtual ~CBCGFileProp();

// Overrides
public:
	virtual void OnClickButton (CPoint point);

// Attributes
protected:
	BOOL m_bIsFolder;

	// File open dialog atributes:
	BOOL	m_bOpenFileDialog;	// TRUE - use "File Open/Save" diaog; otherwise - folder selection dialog
	DWORD	m_dwFileOpenFlags;
	CString	m_strDefExt;
	CString m_strFilter;
};

/////////////////////////////////////////////////////////////////////////////
// CBCGFontProp object

class BCGCONTROLBARDLLEXPORT CBCGFontProp : public CBCGProp
{
	DECLARE_DYNAMIC(CBCGFontProp)

// Construction
public:
	CBCGFontProp(	const CString& strName, LOGFONT& lf, 
					DWORD dwFontDialogFlags = CF_EFFECTS | CF_SCREENFONTS, 
					LPCTSTR lpszDescr = NULL, DWORD dwData = 0);
	virtual ~CBCGFontProp();

// Overrides
public:
	virtual void OnClickButton (CPoint point);
	virtual CString FormatProperty ();

// Attributes
public:
	LPLOGFONT GetLogFont ()
	{
		return &m_lf;
	}

protected:
	LOGFONT	m_lf;
	DWORD	m_dwFontDialogFlags;
};

/////////////////////////////////////////////////////////////////////////////
// CBCGPropList window

#define BCGPROPLIST_ID_INPLACE 3

BCGCONTROLBARDLLEXPORT extern UINT BCGM_PROPERTY_CHANGED;

class BCGCONTROLBARDLLEXPORT CBCGPropList : public CWnd
{
	DECLARE_DYNAMIC(CBCGPropList)

	friend class CBCGProp;
	friend class CBCGProp;
	friend class CBCGColorProp;

// Construction
public:
	CBCGPropList();

// Attributes
public:
	void EnableHeaderCtrl (BOOL bEnable = TRUE,
		LPCTSTR lpszLeftColumn = _T("Property"), 
		LPCTSTR lpszRightColumn = _T("Name"));
	BOOL IsHeaderCtrl () const
	{
		return m_bHeaderCtrl;
	}

	void EnableDescriptionArea (BOOL bEnable = TRUE);
	BOOL IsDescriptionArea () const
	{
		return m_bDescriptionArea;
	}

	int GetDescriptionHeight () const
	{
		return m_nDescrHeight;
	}

	void SetAlphabeticMode (BOOL bSet = TRUE);
	BOOL IsAlphabeticMode () const
	{
		return m_bAlphabeticMode;
	}

	void SetVSDotNetLook (BOOL bSet = TRUE);
	BOOL IsVSDotNetLook () const
	{
		return m_bVSDotNetLook;
	}

	void SetBoolLabels (LPCTSTR lpszTrue, LPCTSTR lpszFalse);

	CRect GetListRect () const
	{
		return m_rectList; 
	}

	int GetPropertyColumnWidth () const 
	{ 
		return m_nLeftColumnWidth; 
	}

	int GetHeaderHeight () const
	{
		return m_nHeaderHeight;
	}

	int	GetRowHeight () const
	{
		return m_nRowHeight;
	}

	int GetLeftColumnWidth () const
	{
		return m_nLeftColumnWidth;
	}

	virtual CBCGHeaderCtrl& GetHeaderCtrl ()
	{
		return m_wndHeader;
	}

	BOOL IsGroupNameFullWidth () const
	{
		return m_bGroupNameFullWidth;
	}

	void SetGroupNameFullWidth (BOOL bGroupNameFullWidth = TRUE, BOOL bRedraw = TRUE);

	BOOL IsShowDragContext () const
	{
		return m_bShowDragContext;
	}

	void SetShowDragContext (BOOL bShowDragContext = TRUE)
	{
		m_bShowDragContext = bShowDragContext;
	}

protected:
	CBCGHeaderCtrl	m_wndHeader;			// Property list header control
	BOOL		m_bHeaderCtrl;			// Is header control visible?

	BOOL		m_bDescriptionArea;		// Does description area enabled?
	int			m_nDescrHeight;			// Description area height

	CToolTipCtrl	m_ToolTip;			// Tooltip control
	int			m_nTooltipsCount;		// Number of tooltip items

	BOOL		m_bAlphabeticMode;		// Use property list in alphabetic (non-"tree") mode
	BOOL		m_bVSDotNetLook;		// Provide MS Visual Studio.NET look (gray groups, flat look)

	CString		m_strTrue;				// Customized boolean value (e.g. "Yes")
	CString		m_strFalse;				// Customized boolean value (e.g. "No")

	CScrollBar	m_wndScrollVert;		// Vertical scroll bar
	HFONT		m_hFont;				// Property list regular font
	CFont		m_fontBold;				// Property list bold font

	int			m_nHeaderHeight;		// Header control height
	CRect		m_rectList;				// Properies area
	int			m_nRowHeight;			// Height of the single row
	int			m_nLeftColumnWidth;		// Width of the left ("Name") column

	int			m_nVertScrollOffset;	// In rows
	int			m_nVertScrollTotal;
	int			m_nVertScrollPage;

	// Tracking attributes: used for the vertical and description area splitters tracking:
	CRect		m_rectTrackHeader;
	CRect		m_rectTrackDescr;
	BOOL		m_bTracking;
	BOOL		m_bTrackingDescr;

	CList<CBCGProp*, CBCGProp*>	m_lstProps;			// List of top-level properties
	CList<CBCGProp*, CBCGProp*>	m_lstTerminalProps;	// List of terminal properties

	CBCGProp*	m_pSel;					// Current selection
	
	BOOL		m_bFocused;				// Control has focus

	COLORREF	m_clrGray;				// Special gray color

	BOOL		m_bControlBarColors;
	BOOL		m_bGroupNameFullWidth;
	BOOL		m_bShowDragContext;

// Operations
public:
	int AddProperty (CBCGProp* pProp, BOOL bRedraw = TRUE);
	void RemoveAll ();

	CBCGProp* GetProperty (int nIndex) const;
	int GetPropertyCount () const
	{
		return m_lstProps.GetCount ();
	}

	CBCGProp* FindItemByData (DWORD dwData, BOOL bSearchSubItems = TRUE) const;

	CBCGProp* HitTest (CPoint pt, CBCGProp::ClickArea* pnArea = NULL) const;

	void SetCurSel (CBCGProp* pProp, BOOL bRedraw = TRUE);
	CBCGProp* GetCurSel () const
	{
		return m_pSel;
	}

	void EnsureVisible (CBCGProp* pProp);

	void CloseColorPopup ();
	void UpdateColor (COLORREF color);

// Overrides
	virtual void OnPropertyChanged (CBCGProp* pProp) const;

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CBCGPropList)
	public:
	virtual BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual CScrollBar* GetScrollBarCtrl(int nBar) const;
	protected:
	virtual void PreSubclassWindow();
	virtual BOOL OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult);
	//}}AFX_VIRTUAL

	virtual void OnChangeSelection (CBCGProp* /*pNewSel*/, CBCGProp* /*pOldSel*/) {}

	virtual BOOL EditItem (CBCGProp* pProp, LPPOINT lptClick = NULL);
	virtual void OnClickButton (CPoint point);
	virtual BOOL EndEditItem (BOOL bUpdateData = TRUE);
	virtual BOOL ValidateItemData (CBCGProp* /*pProp*/)
	{
		return TRUE;
	}

	virtual int OnDrawProperty (CDC* pDC, CBCGProp* pProp) const;
	virtual void InitHeader ();

protected:
	virtual void Init ();
	virtual void AdjustLayout ();

	virtual void OnDrawBorder (CDC* pDC);
	virtual void OnDrawList (CDC* pDC);
	virtual void OnDrawDescription (CDC* pDC, CRect rect);

// Implementation
public:
	virtual ~CBCGPropList();

	// Generated message map functions
protected:
	//{{AFX_MSG(CBCGPropList)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSettingChange(UINT uFlags, LPCTSTR lpszSection);
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnCancelMode();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg BOOL OnMouseWheel(UINT nFlags, short zDelta, CPoint pt);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg HBRUSH OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor);
	afx_msg void OnSysColorChange();
	afx_msg void OnDestroy();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnNcCalcSize(BOOL bCalcValidRects, NCCALCSIZE_PARAMS FAR* lpncsp);
	afx_msg void OnNcPaint();
	//}}AFX_MSG
	afx_msg LRESULT OnSetFont (WPARAM, LPARAM);
	afx_msg LRESULT OnGetFont (WPARAM, LPARAM);
	afx_msg void OnHeaderItemChanged(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnHeaderTrack(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnHeaderEndTrack(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnStyleChanged(int nStyleType, LPSTYLESTRUCT lpStyleStruct);
	afx_msg void OnSelectCombo();
	afx_msg void OnCloseCombo();
	afx_msg BOOL OnNeedTipText(UINT id, NMHDR* pNMH, LRESULT* pResult);
	DECLARE_MESSAGE_MAP()

	//------------------
	// Internal helpres:
	//------------------
	HFONT SetFont (CDC* pDC);
	void TrackHeader (int nOffset);
	void TrackDescr (int nOffset);

	void SetScrollSizes ();

	int GetTotalItems () const;
	void ReposProperties ();

	void CreateBoldFont ();
	void UpdateColors ();
};

#define GetDesciption		 GetDescription
#define SetDesciption		 SetDescription
#define m_bDesciptionArea	 m_bDescriptionArea
#define GetDesciptionHeight	 GetDescriptionHeight
#define OnDrawDesciption	 OnDrawDescription
#define EnableDesciptionArea EnableDescriptionArea
#define IsDesciptionArea	 IsDescriptionArea
#define GetDesciptionHeight	 GetDescriptionHeight

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_BCGPROPLIST_H__8E7648AE_215A_4D66_B6B1_6656A7D6D357__INCLUDED_)
