/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:       o2_linker_opts.lex
Dates:      2 mar. 2005
Purpose:    yacco2's linker frontend command line parser.
            The argv[] data passed by "int main(int argc, char* argv[])" is 
            mapped into raw char tokens and placed into a container 
            for lexical assessment.
Cmd Format: file name
Errors:     "comment-overrun", "bad-eos", "bad-esc", 
            "bad-cmd-lne-opt", "no-int-present", "bad-int-no-range"
            "bad-cmd-opt"
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |o2_linker_opts| grammar.\fbreak
\O2's linker frontend command line parser.
The argv[] data passed by ``int main(int argc, char* argv[])'' is 
mapped into raw char tokens and placed into a container 
for lexical assessment. c++ comments can be sprinkled thru out the command line.
There are no options for the linker just the ``fsc'' extension file.
For example, to process \O2's grammars the linker command line is\fbreak
/usr/local/yacco2/bin/o2linker /yacco2/compiler/grammars/yacco2.fsc\fbreak
@/

fsm	
(fsm-id "o2_linker_opts.lex",fsm-filename o2_linker_opts,fsm-namespace NS_o2_linker_opts
,fsm-class  Co2_linker_opts {
  user-declaration
  public:
  std::string file_to_compile_;
  ***
  user-prefix-declaration
#include "ws.h"
#include "eol.h"
#include "c_comments.h"
#include "xc_str.h"
#include "unq_str.h"
  ***  
  op
    parser__->set_use_all_shift_on();
    file_to_compile_.clear();
  ***
  constructor
    file_to_compile_.clear();
  ***
}
,fsm-version "1.0",fsm-date "21 Nov. 2002",fsm-debug "false"
,fsm-comments "\\Olinker's Command line options parser.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Ro2_lcl_opts  (
lhs{
  op
    TOKEN_GAGGLE* err_queue = (TOKEN_GAGGLE*)rule_info__.parser__->error_queue();
    if(err_queue ->empty()) return;
  ***
}
){
  -> Rws_k Rfile Rws_k Rextra_chaffe
}
 
Rextra_chaffe  (){	
  -> eog
  -> |?|{
    op
      rule_info__.parser__->set_use_all_shift_off();
      CAbs_lr1_sym* sym = new Err_cmd_line_chaffe();
      sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
      ADD_TOKEN_TO_ERROR_QUEUE(*sym);
      rule_info__.parser__->set_stop_parse(true);
    ***  
  }
}

Rws_k  (){	
  -> 
  -> Rws_k_s 
}

Rws_k_s  (){	
  -> Rws
  -> Rws_k_s Rws
}

Rws  (){	
  -> ||| "ws" NS_ws::TH_ws
  -> ||| "comment" NS_c_comments::TH_c_comments {
    op
      sf->p2__->set_auto_delete(true);
    ***
    }
  -> ||| "eol" NS_eol::TH_eol {
    op
      sf->p2__->set_auto_delete(true);
    ***
    }
  -> ||| |?| NULL {
    op
      rule_info__.parser__->set_use_all_shift_off();
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
      rule_info__.parser__->set_stop_parse(true);
    ***
    }
}

Rfile  (
lhs{
  user-declaration
    public:
      void edit_file(CAbs_lr1_sym* Sym){
        using namespace NS_yacco2_err_symbols;
        using namespace NS_yacco2_k_symbols;
        Co2_linker_opts* fsm = (Co2_linker_opts*)rule_info__.parser__->fsm_tbl__;      
        std::ifstream ifile;
        ifile.open(fsm->file_to_compile_.c_str());
	    if (ifile.good()){
	      ifile.close(); 
	      return;
	    }
        CAbs_lr1_sym* sym = new Err_bad_filename(fsm->file_to_compile_);
        sym->set_rc(*Sym,__FILE__,__LINE__);
        ADD_TOKEN_TO_ERROR_QUEUE(*sym);
        rule_info__.parser__->set_stop_parse(true);
      };
  ***
}
){	
  -> ||| "unquoted-string" NS_unq_str::TH_unq_str { 
    op
      T_unquoted_string* uqstr = sf->p2__;
      Co2_linker_opts* fsm = (Co2_linker_opts*)rule_info__.parser__->fsm_tbl__;      
      fsm->file_to_compile_ += uqstr->unquoted_string()->c_str();
      edit_file(uqstr);
      sf->p2__->set_auto_delete(true);
    ***
    }
  -> ||| |?| NULL {  
    op
      rule_info__.parser__->set_use_all_shift_off();
      ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
    ***
    }
  -> ||| "xc-str" NS_xc_str::TH_xc_str { 
    op
      T_xc_str* xcstr = sf->p2__;
      Co2_linker_opts* fsm = (Co2_linker_opts*)rule_info__.parser__->fsm_tbl__;      
      fsm->file_to_compile_ += xcstr->c_string()->c_str();
      edit_file(xcstr);
    ***
    }
  -> |?| { // no file given
    op
      rule_info__.parser__->set_use_all_shift_off();
      CAbs_lr1_sym* sym = new Err_no_filename();
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        ADD_TOKEN_TO_ERROR_QUEUE(*sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
}
}// end of rules
